<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App;
use View;
use Hash;
use Redirect;
use Validator;
use Response;
use Auth;
use Illuminate\Validation\Rule;
use App\User;
use App\Folders;
use App\EnseignantsFiles;
use App\Historique;
use App\Settings;
use App\Subjects;
use App\CahierJournal;
use App\Devoirs;
use App\Classes;
use App\Pointage;
use App\DevoirsAlerts;
use App\Assiduite;
use App\CompteRendu;

use App\AssiduiteMotifs;

use App\ControleContinu;
use App\ControleContinuEvaluations;

use App\AcademicYear;

use App\Emploi;

use App\PlanningDevoirs;

use App\Orientation;

use Excel;

use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{



    public function __construct()
    {
    //    $this->middleware('auth');
    }


    protected function getBrowser()
    {
      if(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== FALSE)
       $BrowserName = 'Internet explorer';
      elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Edge') !== FALSE)    
        $BrowserName = 'Microsoft Edge';
       elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Trident') !== FALSE) 
          $BrowserName = 'Internet explorer';
       elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Firefox') !== FALSE)
         $BrowserName = 'Mozilla Firefox';
       elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== FALSE)
         $BrowserName = 'Google Chrome';
       elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Opera Mini') !== FALSE)
         $BrowserName = "Opera Mini";
       elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Opera') !== FALSE)
         $BrowserName = "Opera";
       elseif(strpos($_SERVER['HTTP_USER_AGENT'], 'Safari') !== FALSE)
         $BrowserName = "Safari";
       else
         $BrowserName = 'Autre';

       return $BrowserName;
    }

    protected function isMobile() {
        return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
    }



    public function login()
    {   

       if (Auth::check()) {

            if (Request()->referrer) {
                return redirect(Request()->referrer);
            }

            else {

                if (auth()->user()->is_admin == 1) {
                    return redirect()->route('admin_index');
                }

                elseif (auth()->user()->is_teacher == 1) {
                   return redirect()->route('enseignant_index');
                }

                elseif (auth()->user()->is_student == 1) {
                   return redirect()->route('students_index');
                }

                else{
                    Auth::logout();
                    return Redirect::route('login');
                }

            }
            
            
        } else {
            return view('login');
        }

    }


    public function login_check(Request $request)
    {   
        
        $inputs = $request->all();

     //   return var_dump($inputs);


        if (!empty($inputs['remember'])) {
            $remember = true;
        } else { $remember = false; }

        $username = e($inputs['username']);
        $password = e($inputs['password']);

        $validation = Validator::make($inputs, ['username'=>'required', 'password'=>'required']);

        if ($validation->fails()) {

            return Redirect::back()->withErrors($validation);

        } else {

            if (Auth::attempt(['username'=>$username, 'password'=>$password], $remember)) {

                Auth::attempt(['username'=>$username, 'password'=>$password], $remember);

                if (Auth::check()) {

                    if($this->isMobile()){
                      $userDevice = 'Mobile';
                    } else {
                      $userDevice = 'Ordinateur';
                    }

                    $appareil = $this->getBrowser() . ' - ' . $userDevice;


                    if (auth()->user()->is_admin == 1) {
                        
                        \App\LoginHistorique::create([
                            'user_id' => Auth::user()->id,
                            'type' => 1,
                            'is_login' => 1,
                            'is_logout' => 0,
                            'appareil' => $appareil,
                        ]);

                        if (!empty($inputs['referrer_url'])) {
                            return redirect($inputs['referrer_url']);
                        } else {
                            return redirect()->route('admin_index');
                        }
                        

                    }

                    else if (auth()->user()->is_teacher == 1) {

                        \App\LoginHistorique::create([
                            'user_id' => Auth::user()->id,
                            'type' => 3,
                            'is_login' => 1,
                            'is_logout' => 0,
                            'appareil' => $appareil,
                        ]);

                        return redirect()->route('enseignant_index');
                    }

                    else if (auth()->user()->is_student == 1) {

                        \App\LoginHistorique::create([
                            'user_id' => Auth::user()->id,
                            'type' => 4,
                            'is_login' => 1,
                            'is_logout' => 0,
                            'appareil' => $appareil,
                        ]);

                        return redirect()->route('students_index');
                    }

                    else{
                        Auth::logout();
                        return Redirect::back()->withError('Vous n\'êtes pas autorisé à accéder à cette page');
                    }
            
                }
                
                
            } else {

                return Redirect::back()->withError('Nom d\'utilisateur ou mot de passe incorrect');


            }
        }
    }



    public function logout(Request $request)
    {   
        if (Auth::check()) {
            if($this->isMobile()){ $userDevice = 'Mobile'; } else { $userDevice = 'Ordinateur';}
            $appareil = $this->getBrowser() . ' - ' . $userDevice;

            if (auth()->user()->is_admin == 1) { $user_type = 1;}
            if (auth()->user()->is_personnel == 1) { $user_type = 2;}
            if (auth()->user()->is_teacher == 1) { $user_type = 3;}
            if (auth()->user()->is_student == 1) { $user_type = 4;}

            \App\LoginHistorique::create([
                'user_id' => Auth::user()->id,
                'type' => $user_type,
                'is_login' => 0,
                'is_logout' => 1,
                'appareil' => $appareil,
            ]);
        }


        Auth::logout();
        return Redirect::route('login');

    }

/*---------------

    admin index

--------------*/


    public function admin_index()
    {   
        $settings = Settings::first();

        $folders = Folders::orderBy('id', 'desc')->get();

        $files = EnseignantsFiles::orderBy('id', 'desc')->get();

        $enseignants = User::where('is_teacher', true)->orderBy('id', 'desc')->get();

        $devoirs = Devoirs::where('preparation_exam', null)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        $controlesContinu = ControleContinu::where('year_id', $settings->default_year)->get();
            
        return view('admin.index', compact('folders', 'files', 'enseignants', 'devoirs', 'controlesContinu'));
    }



    public function enseignant_dossiers()
    {   
        $settings = Settings::first();

        $classes = \App\Classes::orderBy('name', 'asc')->get();

        $folders = Folders::orderBy('id', 'desc')->paginate(30);

        return view('admin.folders', compact('folders', 'classes'));
    }

    public function enseignants_nondepose()
    {   
        $settings = Settings::first();
                
        //$monday = strtotime('last monday', strtotime(date('2021-04-22')));
        $monday = strtotime('last monday', strtotime('tomorrow'));
        $sunday = strtotime('+5 days', $monday);
        //echo "<P>". date('Y-m-d', $monday) . " to " . date('Y-m-d', $sunday) . "</P>";

        $from = date('Y-m-d', $monday) . ' 00:00:01';
        $to = date('Y-m-d', $sunday) . ' 23:59:59';

        $fromFR = \DateTime::createFromFormat('Y-m-d', date('Y-m-d', $monday)); 
        $toFR = \DateTime::createFromFormat('Y-m-d', date('Y-m-d', $sunday)); 

        $CheckEnseignantsFiles = \App\EnseignantsFiles::whereBetween('created_at', [$from, $to])->get();

        $array_ids = array();
        foreach ($CheckEnseignantsFiles as $CheckEnseignantsFile) {
          $array_ids[] = $CheckEnseignantsFile->teacher_id;
        }

        $listNotDepose = \App\User::where('is_teacher', true)->whereNotIn('id', $array_ids)->orderBy('last_name', 'asc')->get();


        return view('admin.enseignants_nondepose', compact('listNotDepose', 'fromFR', 'toFR'));
    }


    public function enseignant_dossiers_files($id)
    {   
        $folder = Folders::find(e($id));

        if ($folder !== null) {

            $files = EnseignantsFiles::where('folder_id', $folder->id)->orderBy('id', 'desc')->get();

            return view('enseignants.folder_files', compact('folder', 'files'));
           
        } else {
            return View::make('404');
        }
    }


    public function folder_delete($id)
    {   
        $folder = Folders::find(e($id));

        if ($folder !== null) {

            //---> RessourcesNotification
            \App\RessourcesNotification::where('folder_id', $folder->id)->delete();


            $files = EnseignantsFiles::where('folder_id', $folder->id)->orderBy('id', 'desc')->get();

            foreach ($files as $file) {

                if (!empty($file->file_path)) {
                    unlink(public_path()."/uploads/files/".$file->file_path);
                }

                $file->delete();
            }


            $folder->delete();

            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }



    public function file_delete($id)
    {   
        $EnseignantsFiles = EnseignantsFiles::find(e($id));

        if ($EnseignantsFiles !== null) {

            if (!empty($EnseignantsFiles->file_path)) {
                unlink(public_path()."/uploads/files/".$EnseignantsFiles->file_path);
            }

            $EnseignantsFiles->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }



/*---------------

    historique

--------------*/

    public function historique()
    {   
        $historique = Historique::orderBy('id', 'desc')->get();

        $settings = Settings::first();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        return view('admin.historique', compact('historique', 'classes'));
    }


    public function historique_delete($id)
    {   
        $Historique = Historique::find(e($id));

        if ($Historique !== null) {

            $Historique->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }


    public function historique_delete_all()
    {   
        if (auth()->user()->is_admin == 1) {

            DB::table('historique')->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');

        } else {
            return View::make('404');
        }
            
           
        
    }



    public function ressources_historique(Request $request)
    {   
        
        $inputs = $request->all();

        return View::make('admin.ressources_historique', compact('inputs'));
        
    }






/*---------------

    repartition

--------------*/
    
    public function repartition()
    {   
        $settings = Settings::first();

        $subjects = Subjects::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return view('admin.repartition', compact('subjects'));
    }





/*---------------

    cahier journal

--------------*/
    
    public function cahier_journal()
    {   
        $settings = Settings::first();

        $enseignants = User::where('is_teacher', true)->orderBy('last_name', 'asc')->get();

        $cahier_journal = \App\CahierJournal::where('year_id', $settings->default_year)->orderBy('id', 'desc')->paginate(500);

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        $subjects = Subjects::where('year_id', $settings->default_year)->orderBy('class_id', 'asc')->get();

        return view('admin.cahier_journal', compact('settings', 'enseignants', 'cahier_journal', 'classes', 'subjects'));
    }


    public function cahier_journal_print($id)
    { 

        $journal = CahierJournal::find(e($id));

        if ($journal !== null) {

            return view('admin.cahier_journal_print', compact('journal'));
           

        } else {
            return View::make('404');
        }
    }


    public function journal_historique()
    { 
        $settings = Settings::first();

        return view('admin.cahier_journal_historique', compact('settings'));
        
    }


    public function cahier_journal_print_all()
    { 
        $settings = Settings::first();

        return view('admin.cahier_journal_print_all', compact('settings'));
        
    }

    public function cahier_journal_honoraire()
    { 
        $settings = Settings::first();

        return view('admin.cahier_journal_honoraire', compact('settings'));
        
    }


    public function cahier_journal_edit($id)
    { 

        $journal = CahierJournal::find(e($id));

        if ($journal !== null) {

            return view('admin.cahier_journal_edit', compact('journal'));
           

        } else {
            return View::make('404');
        }
    }

    public function cahier_journal_update($id, Request $request)
    { 
        $inputs = $request->all();

        $journal = CahierJournal::find(e($id));


$heures = explode(" - ", $inputs['seance_heures']);

$time1 = $heures[0];
$time2 = $heures[1];

$to_time = strtotime($time1.":00");
$from_time = strtotime($time2.":00");
$hours_differance = round(abs($to_time - $from_time) / 60,2);

                $myDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['date']));
                $date_en = $myDateTime->format('Y-m-d');


                $journal->date_en = $date_en;
                $journal->date = e($inputs['date']);
                $journal->hour_start = $time1;
                $journal->hour_end = $time2;
                $journal->details = htmlentities($inputs['details']);
                $journal->hours_differance = $hours_differance;
                $journal->save();

                return Redirect::back()->withSuccess('Modifié avec succès');
           
    }



/*---------------

    devoirs

--------------*/
    
    public function devoirs()
    {   
        $settings = Settings::first();

        $devoirs = Devoirs::where('preparation_exam', null)->where('year_id', $settings->default_year)->orderBy('id', 'desc')->paginate(500);

        return View::make('admin.devoirs', compact('devoirs'));
    }



    public function devoirs_non_depose(Request $request)
    {   
        
        $inputs = $request->all();

        $fromDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['from']));
        $toDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['to']));
        
        $from = date($fromDateTime->format('Y-m-d')) . ' 00:00:00' ;
        $to = date($toDateTime->format('Y-m-d')) . ' 23:59:59' ;

        $enseignants = User::where('is_teacher', true)->orderBy('last_name', 'asc')->get();

        return View::make('admin.devoirs_non_depose', compact('enseignants', 'from', 'to'));
        
    }



    public function public_devoirs()
    {   
    	/*
        $settings = Settings::first();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('devoirs', compact('classes', 'settings'));
        */

        return Redirect::route('login');

    }


/*---------------

    assiduite

--------------*/
    
    public function admin_assiduite()
    {   
        $settings = Settings::first();

        $assiduite = Assiduite::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        foreach ($assiduite as $assidu) {
            $assidu->readed = 1;
            $assidu->save();
        }

        return View::make('admin.assiduite', compact('assiduite', 'classes'));
    }


    public function assiduite_historique(Request $request)
    {   
        
        $inputs = $request->all();

        $assiduite = Assiduite::where('student_id', e($inputs['student_id']));

        if (!empty(e($inputs['from'])) AND !empty(e($inputs['to']))) {

            $fromDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['from']));
            $toDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['to']));
            
            $from = date($fromDateTime->format('Y-m-d')) . ' 00:00:01' ;
            $to = date($toDateTime->format('Y-m-d')) . ' 23:59:59' ;

            $assiduite = $assiduite->whereBetween('created_at', [$from, $to]);
        }

        $assiduite = $assiduite->orderBy('created_at', 'asc')->get();

        $student = \App\User::find(e($inputs['student_id']));

        return View::make('admin.assiduite_historique', compact('assiduite', 'inputs', 'student'));
        
    }



/*---------------

     compte rendu

--------------*/
    
    public function admin_compte_rendu()
    {   
        $settings = Settings::first();

        $compte_rendu = CompteRendu::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('enseignants.compte_rendu', compact('compte_rendu'));
    }


/*---------------

    Préparation à l'exam

--------------*/
    
    public function preparation_exam()
    {   
        $settings = Settings::first();

        $devoirs = Devoirs::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('admin.preparation', compact('devoirs'));
    }


/*---------------

    devoirs alerts

--------------*/
    
    public function devoirs_alerts()
    {   
        $settings = Settings::first();

        $devoirs_alerts = DevoirsAlerts::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('admin.devoirs_alerts', compact('devoirs_alerts'));
    }

    
/*---------------------

    Contrôle continu

---------------------*/

    public function evaluations_controle()
    {   
        $settings = Settings::first();

        $controlesContinu = ControleContinu::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('enseignants.controle_continu', compact('controlesContinu'));
            
    }



/*---------------------

    Simili

---------------------*/

    public function admin_evaluations_simili()
    {   
        $settings = Settings::first();

        $similis = \App\Simili::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        return View::make('enseignants.simili', compact('similis'));
            
    }





/*---------------

    pointage

--------------*/
    


    public function personnel_badges()
    {   
        $settings = Settings::first();
        $academic_year = AcademicYear::find($settings->default_year);

        $personnel = User::where('is_personnel', true)->orderBy('last_name', 'asc')->get();
        return View::make('admin.badges_personnel', compact('personnel', 'academic_year'));
    }


    public function enseignants_badges()
    {   
        $settings = Settings::first();
        $academic_year = AcademicYear::find($settings->default_year);

        $enseignants = User::where('is_teacher', true)->orderBy('last_name', 'asc')->get();
        return View::make('admin.badges_teachers', compact('enseignants', 'academic_year'));
    }


    public function students_badges()
    {   
        $settings = Settings::first();
        $academic_year = AcademicYear::find($settings->default_year);

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->paginate(1);

        return View::make('admin.badges_students', compact('classes', 'academic_year'));
    }


    public function pointage()
    {   
        //return var_dump(\Session::get('pointagePASSWORD'));
        if (\Session::get('pointagePASSWORD') == null) {
            return Redirect::route('pointagelogin');
        } else {
            return View::make('pointage');
        }
        
    }

    public function pointagelogin()
    {   

        if (\Session::get('pointagePASSWORD') == null) {
            return View::make('pointage_login');
        } else {
            return Redirect::route('pointage');
        }
        
    }


    public function pointage_historique()
    {   
        $historique = Pointage::orderBy('id', 'desc')->get();
        return View::make('admin.pointage_historique', compact('historique'));
    }



    public function pointage_historique_print(Request $request)
    {
        
        $inputs = $request->all();

        if (!empty(e($inputs['from'])) AND !empty(e($inputs['to']))) {
          
          $fromDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['from']));
          $toDateTime = \DateTime::createFromFormat('d/m/Y', e($inputs['to']));
        

            $from = date($fromDateTime->format('Y-m-d')) . ' 00:00:00' ;
            $to = date($toDateTime->format('Y-m-d')) . ' 23:59:59' ;


             $from_fr = $inputs['from'];
             $to_fr = $inputs['to'];

            $historique = Pointage::whereBetween('created_at', [$from, $to])->get();

            return View::make('admin.pointage_historique_print', compact('historique', 'from_fr', 'to_fr'));

        }



    }



    public function pointage_scan(Request $request)
    {   

        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'barcode'=>'required',
        
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {

        //    $getNum = substr($inputs['barcode'], 0, 12);

            $checkBarcode = User::where('barcode', e($inputs['barcode']))->first();

            if ($checkBarcode == null) { 
                return 'no_exist';
                die();
            } 

            else {

                

/*
//---> test QR
                $date = date("Y-m-d");
                $today = date('l', strtotime($date));


                $CheckPointage = pointage::where('teacher_id', $checkBarcode->id)->where('day_id', $today)->get();


                $number = count($CheckPointage);
                if ($number > 0) {
                    if ($number % 2 == 0) { $type = 1; } else { $type = 2; }
                } else {
                    $type = 1;
                }



                $settings = Settings::first();

                $pointage = Pointage::create([
                    'teacher_id' => $checkBarcode->id,
                    'day_id' => $today,
                    'type' => $type,
                    'late_minutes' => 0,
                    'year_id' => $settings->default_year,
                ]);

                $pointage->save();


                return response()->json([
                    'image' => $checkBarcode->image,
                    'first_name' => $checkBarcode->first_name,
                    'last_name' => $checkBarcode->last_name,
                    'late' => '',
                ]);


                 die();

//---> END Test QR
*/



                $date = date("Y-m-d");
                $today = date('l', strtotime($date));


                if ($checkBarcode->is_student == 1) {
                    $CheckPointage = pointage::where('student_id', $checkBarcode->id)->where('day_id', $today)->get();
                } elseif ($checkBarcode->is_personnel == 1) {
                    $CheckPointage = pointage::where('personnel_id', $checkBarcode->id)->where('day_id', $today)->get();
                } else {
                    $CheckPointage = pointage::where('teacher_id', $checkBarcode->id)->where('day_id', $today)->get();
                }

                $number = count($CheckPointage);
                if ($number > 0) {
                    if ($number % 2 == 0) { $type = 1; } else { $type = 2; }
                } else {
                    $type = 1;
                }


                //--> scan students
                if ($checkBarcode->is_student == 1) { 

                    $pointage = Pointage::create([
                        'student_id' => $checkBarcode->id,
                        'day_id' => $today,
                        'type' => $type,
                        'late_minutes' => 0,
                        'year_id' => $settings->default_year,
                    ]);

                    $pointage->save();

                    return response()->json([
                        'image' => $checkBarcode->image,
                        'first_name' => $checkBarcode->first_name,
                        'last_name' => $checkBarcode->last_name,
                        'late' => '',
                    ]);
                    die();
                }


                //--> scan personnel
                if ($checkBarcode->is_personnel == 1) { 

                    $pointage = Pointage::create([
                        'personnel_id' => $checkBarcode->id,
                        'day_id' => $today,
                        'type' => $type,
                        'late_minutes' => 0,
                        'year_id' => $settings->default_year,
                    ]);

                    $pointage->save();

                    return response()->json([
                        'image' => $checkBarcode->image,
                        'first_name' => $checkBarcode->first_name,
                        'last_name' => $checkBarcode->last_name,
                        'late' => '',
                    ]);
                    die();
                }



                $get_horaires_travail = \App\HorairesTravail::where('teacher_id', $checkBarcode->id)->where('day_id', $today);


                if (count($get_horaires_travail->get()) == 0) { 
                    return response()->json([
                        'image' => $checkBarcode->image,
                        'first_name' => $checkBarcode->first_name,
                        'last_name' => $checkBarcode->last_name,
                        'errormsg' => 'no_hours',
                    ]);
                    die();
                }

            //    if (count($horaires_travail) * 2 <= count($CheckPointage)) { return 'max_scan'; die();}
                

                $currentTime = strtotime(date('H:i'));
                $late_minutes = 0;

                if ($currentTime <= strtotime(date('12:00'))) {

                    $horaires_oldest = $get_horaires_travail->oldest('entry_time')->first();

                } else {

                    $horaires_oldest = $get_horaires_travail->where('entry_time', '>=', '12:00')->oldest('entry_time')->first();

                }


                if ($horaires_oldest == null) { 
                    return response()->json([
                        'image' => $checkBarcode->image,
                        'first_name' => $checkBarcode->first_name,
                        'last_name' => $checkBarcode->last_name,
                        'errormsg' => 'no_hours',
                    ]);
                    die();
                }
                
                if ($currentTime >= strtotime($horaires_oldest->entry_time)) {
                        
                    if ($type == 1) {
                        $late_minutes = round(abs($currentTime - strtotime($horaires_oldest->entry_time)) / 60,2);
                    }
                }



                $pointage = Pointage::create([
                    'teacher_id' => $checkBarcode->id,
                    'day_id' => $today,
                    'type' => $type,
                    'late_minutes' => $late_minutes,
                    'year_id' => $settings->default_year,
                ]);

                $pointage->save();

                if ($late_minutes > 0) {

                    return response()->json([
                        'image' => $checkBarcode->image,
                        'first_name' => $checkBarcode->first_name,
                        'last_name' => $checkBarcode->last_name,
                        'late' => 'Retard: ' . $late_minutes . ' minutes',
                    ]);

                } else {
                    return response()->json([
                        'image' => $checkBarcode->image,
                        'first_name' => $checkBarcode->first_name,
                        'last_name' => $checkBarcode->last_name,
                        'late' => '',
                    ]);
                } 
                



            }



        }



    }


    public function pointage_delete($id)
    {   
        $Pointage = Pointage::find(e($id));

        if ($Pointage !== null) {

            $Pointage->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');
            
           
        } else {
            return View::make('404');
        }
        
    }


    public function pointage_delete_delete_all()
    {   
        if (auth()->user()->is_admin == 1) {

            DB::table('pointage_historique')->delete();
    
            return Redirect::back()->withError('Supprimé avec succès');

        } else {
            return View::make('404');
        }
            
           
        
    }






/*---------------------

    Emploi du temps

---------------------*/

    public function emploi()
    {   
        $settings = Settings::first();

        $emploi = emploi::orderBy('id', 'desc')->get();

        $Depotdocuments = \App\DepotDocument::orderBy('id', 'desc')->get();

        $enseignants = User::where('is_teacher', true)->orderBy('last_name', 'asc')->get();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        return View::make('admin.emploi', compact('emploi', 'classes', 'enseignants', 'Depotdocuments'));
            
    }

    public function emploi_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

    //    return dd($inputs);

        $validation = Validator::make($inputs, [
          'type'=>'required',
          'file_join'=>'max:10240',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


$destinationPath = public_path().'/uploads/emploi';

$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx"
);

    
            if ($request->hasFile('file_join')) {

                if (!(in_array($request->file('file_join')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $file_join = round(microtime(true)) .'.'. $request->file('file_join')->extension();

                    $request->file('file_join')->move($destinationPath, $file_join);
                }

            } else {
                $file_join = null;
            }




//--> Emploi du temps
if (e($inputs['doc_type']) == 1) {


            // type Classes
            if (e($inputs['type']) == 1) {

                //--> check OLD 
                $OLDemploi = Emploi::where('type', e($inputs['type']))->where('class_id', e($inputs['class_id']))->first();

                // DELETE OLD EMPLOI
                if ($OLDemploi !== null) {
                   if (!empty($OLDemploi->fichier)) {

                        $CheckFilename1 = public_path()."/uploads/emploi/".$OLDemploi->fichier;
                        if (file_exists($CheckFilename1)) {
                           unlink(public_path()."/uploads/emploi/".$OLDemploi->fichier);
                        }

                        
                    }

                    $OLDemploi->delete();
                }


                $store = Emploi::create([
                    'type' => e($inputs['type']),
                    'class_id' => e($inputs['class_id']),
                    'fichier' => $file_join,
                ]);

                $store->save();


                //--> store notification
                $students = User::where('is_student', true)->where('class_id', e($inputs['class_id']))->get();

                foreach ($students as $student) {
                    
                    $notif = \App\EmploiNotification::create([
                        'user_id' => $student->id,
                    ]);

                    $notif->save();
                }
                //--> End store notification



            } 

            // type Enseignants
            else {


                //--> for teacher_id
                for($i=0;$i<count($inputs['teacher_id']);$i++){

                    //--> delete OLD 
                    Emploi::where('type', e($inputs['type']))->where('teacher_id', $inputs['teacher_id'][$i])->delete();

                    Emploi::create([
                        'type' => e($inputs['type']),
                        'teacher_id' => $inputs['teacher_id'][$i],
                        'fichier' => $file_join,
                    ]);

                    //--> store notification
                    \App\EmploiNotification::create([
                        'user_id' => $inputs['teacher_id'][$i],
                    ]);


                }


            }


            


            return Redirect::back()->withSuccess('Ajouter avec succès');




} 

//--> Autre document
else {  

            // type Classes
            if (e($inputs['type']) == 1) {

                if ($inputs['class_ids'][0] == 'all') {

                    $allClasses = Classes::orderBy('name', 'asc')->get();

                    foreach ($allClasses as $classe) {
                        \App\DepotDocument::create([
                            'type' => e($inputs['type']),
                            'doc_name' => e($inputs['doc_name']),
                            'class_id' => $classe->id,
                            'fichier' => $file_join,
                        ]);
                    }


                } else {

                    if (empty($inputs['student_id'])) {

                        //--> for class_ids
                        for($i=0;$i<count($inputs['class_ids']);$i++){
                            \App\DepotDocument::create([
                                'type' => e($inputs['type']),
                                'doc_name' => e($inputs['doc_name']),
                                'class_id' => $inputs['class_ids'][$i],
                                'fichier' => $file_join,
                            ]);
                        }

                    } else {

                        \App\DepotDocument::create([
                            'type' => e($inputs['type']),
                            'doc_name' => e($inputs['doc_name']),
                            'student_id' => e($inputs['student_id']),
                            'fichier' => $file_join,
                        ]);

                    }


                }


                
            } 

            // type Enseignants
            else {

                if ($inputs['teacher_ids'][0] == 'all') {
                    
                    $allTeachers = User::where('is_teacher', true)->get();

                    foreach ($allTeachers as $teacher) {

                        \App\DepotDocument::create([
                            'type' => e($inputs['type']),
                            'doc_name' => e($inputs['doc_name']),
                            'teacher_id' => $teacher->id,
                            'fichier' => $file_join,
                        ]);

                    }

                } else {

                    //--> for teacher_ids
                    for($i=0;$i<count($inputs['teacher_ids']);$i++){

                        \App\DepotDocument::create([
                            'type' => e($inputs['type']),
                            'doc_name' => e($inputs['doc_name']),
                            'teacher_id' => $inputs['teacher_ids'][$i],
                            'fichier' => $file_join,
                        ]);


                    }

                }

                

            }

            return Redirect::back()->withSuccess('Ajouter avec succès');




}




        }


    }



    public function emploi_delete($id)
    { 

        $emploi = Emploi::find(e($id));

        if ($emploi !== null) {

            $checkfile = Emploi::where('fichier', $emploi->fichier)->where('id', '!=' ,$emploi->id)->first();
            
            if ($checkfile == null) {
                if (!empty($emploi->fichier)) {
                    unlink(public_path()."/uploads/emploi/".$emploi->fichier);
                }
            }


            $emploi->delete();

            return Redirect::back()->withError('Supprimé avec succès');


        } else {
            return View::make('404');
        }
    }


    public function depot_document_delete($id)
    { 

        $DepotDoc = \App\DepotDocument::find(e($id));

        if ($DepotDoc !== null) {

            $checkfile = \App\DepotDocument::where('fichier', $DepotDoc->fichier)->where('id', '!=' ,$DepotDoc->id)->first();
            
            if ($checkfile == null) {
                if (!empty($DepotDoc->fichier)) {
                    unlink(public_path()."/uploads/emploi/".$DepotDoc->fichier);
                }
            }
            

            $DepotDoc->delete();

            return Redirect::back()->withError('Supprimé avec succès');


        } else {
            return View::make('404');
        }
    }



    public function enseignant_emploi()
    { 

        $emploi = Emploi::where('teacher_id', auth()->user()->id)->first();


        $GetNotification = \App\EmploiNotification::where('readed', 0)->where('user_id', auth()->user()->id)->get();

        foreach ($GetNotification as $GetNotif) {
            $GetNotif->delete();
        }

        return View::make('admin.emploi_users', compact('emploi'));

    }

    public function students_emploi()
    { 

//--> Activites Historique
$user_type = 3; //-> student
\App\ActivitesHistorique::create([
    'user_id' => Auth::user()->id,
    'type' => $user_type,
    'rubrique' => 'Emploi du temps',
]);
//--> End Activites Historique

        $emploi = Emploi::where('class_id', auth()->user()->class_id)->first();

        $GetNotification = \App\EmploiNotification::where('readed', 0)->where('user_id', auth()->user()->id)->get();

        foreach ($GetNotification as $GetNotif) {
            $GetNotif->delete();
        }

        return View::make('admin.emploi_users', compact('emploi'));

    }


    public function students_depot_document()
    { 
        
        $Depotdocuments = \App\DepotDocument::where('class_id', auth()->user()->class_id)->orWhere('student_id', auth()->user()->id)->get();

        return View::make('admin.depot_document_users', compact('Depotdocuments'));

    }

    public function enseignant_depot_document()
    { 
        
        $Depotdocuments = \App\DepotDocument::where('teacher_id', auth()->user()->id)->get();

        foreach ($Depotdocuments as $Depotdocument) {
            $Depotdocument->is_readed = 1;
            $Depotdocument->save();
        }

        return View::make('admin.depot_document_users', compact('Depotdocuments'));

    }









/*---------------------

    planning des devoirs

---------------------*/

    public function planning_devoirs()
    {   
        $settings = Settings::first();

        $planning_devoirs = PlanningDevoirs::orderBy('id', 'desc')->get();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        return View::make('admin.planning_devoirs', compact('planning_devoirs', 'classes'));
            
    }

    public function planning_devoirs_store(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
         // 'class_id'=>'required',
          'file_join'=>'max:10240',
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


$destinationPath = public_path().'/uploads/planning_devoirs';

$whitelist = array(
    "jpg","jpeg","gif","png","bmp",
    "pdf","doc","docx","txt","ppt","pptx","xls","xlsx"
);

    
            if ($request->hasFile('file_join')) {

                if (!(in_array($request->file('file_join')->extension(), $whitelist))) {
                    return Redirect::back()->withInput()->withError('Extension non autorisée');
                    die();
                } else {

                    $file_join = round(microtime(true)) .'.'. $request->file('file_join')->extension();

                    $request->file('file_join')->move($destinationPath, $file_join);
                }

            } else {
                $file_join = null;
            }



            if ($inputs['class_id'][0] == 'all') {
                    
                    $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

                    foreach ($classes as $classe) {

                        $store = PlanningDevoirs::create([
                            'date_du' => e($inputs['date_du']),
                            'date_au' => e($inputs['date_au']),
                            'class_id' => $classe->id,
                            'fichier' => $file_join,
                        ]);

                        $store->save();

                        //--> store notification
                        $students = User::where('is_student', true)->where('class_id', $classe->id)->get();

                        foreach ($students as $student) {
                            
                            \App\PlanningDevoirsNotifs::create([
                                'user_id' => $student->id,
                                'planning_id' => $store->id,
                            ]);

                        }
                        //--> End store notification


                    }

            } else {

                    //--> loop class_id
                    for($i=0;$i<count($inputs['class_id']);$i++){

                        $store = PlanningDevoirs::create([
                            'date_du' => e($inputs['date_du']),
                            'date_au' => e($inputs['date_au']),
                            'class_id' => $inputs['class_id'][$i],
                            'fichier' => $file_join,
                        ]);

                        $store->save();


                        //--> store notification
                        $students = User::where('is_student', true)->where('class_id', $inputs['class_id'][$i])->get();

                        foreach ($students as $student) {
                            
                            \App\PlanningDevoirsNotifs::create([
                                'user_id' => $student->id,
                                'planning_id' => $store->id,
                            ]);

                        }
                        //--> End store notification


                    }

            }




            return Redirect::back()->withSuccess('Ajouter avec succès');

        }

    }



    public function planning_devoirs_delete($id)
    { 

        $Planning = PlanningDevoirs::find(e($id));

        if ($Planning !== null) {


            $checkfile = PlanningDevoirs::where('fichier', $Planning->fichier)->where('id', '!=' ,$Planning->id)->first();
            
            if ($checkfile == null) {
                if (!empty($Planning->fichier)) {
                   unlink(public_path()."/uploads/planning_devoirs/".$Planning->fichier);
                }
            }



            \App\PlanningDevoirsNotifs::where('planning_id', $Planning->id)->delete();

            $Planning->delete();

            return Redirect::back()->withError('Supprimé avec succès');


        } else {
            return View::make('404');
        }
    }






/*---------------

    orientation

--------------*/
    

    public function orientation()
    {   
        $settings = Settings::first();

        $orientation_students = \App\OrientationStudents::orderBy('id', 'desc')->get();

        return View::make('admin.orientation_students', compact('orientation_students'));
    }

    public function exporter_orientation()
    {   
        return Excel::download(new App\Exports\OrientationExport, 'Orientation_'.date("d-m-Y").'.xlsx');
    }


    public function update_orientation($id, Request $request)
    { 
        $inputs = $request->all();

        $OrientStudent = \App\OrientationStudents::find(e($id));

        if ($OrientStudent !== null) {

            $OrientStudent->orientation = $inputs['orientation'];
            $OrientStudent->save();

            return Redirect::route('admin_orientation')->withSuccess('Mise à jour avec succès');

        } else {
            return View::make('404');
        }
    }


    public function delete_orientation($id)
    { 

        $OrientStudent = \App\OrientationStudents::find(e($id));

        if ($OrientStudent !== null) {

            $OrientStudent->delete();

            return Redirect::back()->withError('Supprimé avec succès');

        } else {
            return View::make('404');
        }
    }



    public function orientation_classes()
    {   
        $settings = Settings::first();

        $orientation = Orientation::where('year_id', $settings->default_year)->orderBy('id', 'desc')->get();

        $classes = Classes::where('year_id', $settings->default_year)->orderBy('name', 'asc')->get();

        return View::make('admin.orientation', compact('orientation', 'classes'));
    }


    

    public function store_orientation_classes(Request $request)
    {   
        $settings = Settings::first();

        $inputs = $request->all();

        $validation = Validator::make($inputs, [
          'class_ids'=>'required',
        
        ]); 

        if ($validation->fails()) {
            return Redirect::back()->withInput()->withErrors($validation);
        } 

        else {


            $comma_separated = implode(",", $inputs['orientations']);

            //--> for class_ids
            for($i=0;$i<count($inputs['class_ids']);$i++){

                Orientation::create([
                    'class_id' => $inputs['class_ids'][$i],
                    'orientations' => $comma_separated,
                    'year_id' => $settings->default_year,
                ]);

            }

            return Redirect::back()->withSuccess('Ajouter avec succès');

        }


    }


    public function delete_orientation_classes($id)
    { 

        $Orient = Orientation::find(e($id));

        if ($Orient !== null) {


            \App\OrientationStudents::where('orient_id', $Orient->id)->delete();

            $Orient->delete();

            return Redirect::back()->withError('Supprimé avec succès');


        } else {
            return View::make('404');
        }
    }










}