<?php

namespace App\Imports;

use Hash;
use App\User;
use Maatwebsite\Excel\Concerns\ToModel;

use Maatwebsite\Excel\Concerns\WithStartRow;

use Illuminate\Http\Request;

// use Maatwebsite\Excel\Concerns\WithMultipleSheets;


class StudentsImport implements ToModel, WithStartRow 
{
    

    public function startRow(): int
    {
        return 2;
    }


    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   

        $input = request()->all();
        
        if(!empty($row[0]) AND !empty($row[1]) AND !empty($row[2])) {

            $check = User::where('username', $row[2])->first();

            if($check  == null) {

                $barcode = date('Y').rand(11111, 99999);

                $checkBarcode = User::where('barcode', $barcode)->first();

                if ($checkBarcode == null) {

                    return new User([
                        'is_student'     => 1,

                        'class_id'     => e($input['class_id']),

                        'last_name'     => $row[0],
                        'first_name'    => $row[1], 
                        'username'    => $row[2], 
                        'email'    => $row[2], 
                        'password' => Hash::make($row[3]),
                        'barcode' => $barcode,
                    ]);

                }

                

            }

        }

        /*

        if(!empty($row[4])) {

            $check = User::where('username', $row[4])->first();

            if($check !== null) {

                $check->phone = $row[0];
                $check->save();

            }

        }

        */
        
        
    } 
}
