<!doctype html>
<html lang="fr">
 
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta name="csrf-token" content="{{ csrf_token() }}" />
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap/css/bootstrap.min.css">
    <link href="{{url('/')}}/assets/vendor/fonts/circular-std/style.css" rel="stylesheet">
    <link rel="stylesheet" href="{{url('/')}}/assets/libs/css/style.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/fontawesome/css/fontawesome-all.css">
    
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/material-design-iconic-font/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/charts/c3charts/c3.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/flag-icon-css/flag-icon.min.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/charts/morris-bundle/morris.css">

    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap-select/css/bootstrap-select.css">

    <title>@yield('title')</title>
    @yield('CSS')

    <style type="text/css">
        .bootstrap-select .dropdown-menu { z-index: 99999; }
        .slimScrollBar {  
            display: block !important;
 
            opacity: 1 !important;
            padding:4px 7px 4px 7px !important;

            background: rgb(114,136,255) !important;
            background: linear-gradient(90deg, rgba(114,136,255,1) 0%, rgba(114,136,255,1) 44%, rgba(27,63,255,1) 100%) !important;

        }
        .slimScrollDiv { height: 90% !important; }

        .sidebar-dark3 .nav-item a, .sidebar-dark3 .nav-item i{ 
            color: #1B3FFF !important;
        }

        .sidebar-dark3 .nav-item a{ 
            font-weight: bold !important;
            font-size: 14px !important;
        }

        .submenu {
            background-color: #efeff6 !important;
        }
    </style>



</head>

<body>
    <!-- ============================================================== -->
    <!-- main wrapper -->
    <!-- ============================================================== -->
    <div class="dashboard-main-wrapper">
        <!-- ============================================================== -->
        <!-- navbar -->
        <!-- ============================================================== -->
        <div class="dashboard-header">
            <nav class="navbar navbar-expand-lg bg-white fixed-top">
                <a style="font-size: 18px;" class="navbar-brand" href="{{url('/')}}">
                    <img class="logo-img img-fluid" width="160px" src="{{url('/')}}/assets/images/logo4.png" alt="Groupe Scolaire Verdin"> 
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse " id="navbarSupportedContent">
                    <ul class="navbar-nav ml-auto navbar-right-top">

@if(auth()->user()->is_student == 1) 

                        <li class="nav-item">
                            <div id="custom-search" class="top-search-bar">
                                <h3 class="mt-1">Élève: <strong style="color: #0328EB;" >{{ auth()->user()->last_name . ' ' .  auth()->user()->first_name }}</strong>

                                 @if(auth()->user()->is_student == 1) 

                    @if(!empty(auth()->user()->class_id))
                    <?php $getuserClasse = \App\Classes::find(auth()->user()->class_id); ?>

                    <br>Classe: <strong style="color: #0328EB;">{{ $getuserClasse->name }}</strong>

                    @endif
                    @endif
                                </h3>
                            </div>
                        </li>
@else
                        
                        <li class="nav-item">
                            <div id="custom-search" class="top-search-bar">
                                <h3 class="mt-1">Vous êtes connecté en tant que: <strong style="color: #0328EB;" >{{ auth()->user()->last_name . ' ' .  auth()->user()->first_name }}</strong>

                                 @if(auth()->user()->is_student == 1) 

                    @if(!empty(auth()->user()->class_id))
                    <?php $getuserClasse = \App\Classes::find(auth()->user()->class_id); ?>

                    <br>Classe: <strong style="color: #0328EB;">{{ $getuserClasse->name }}</strong>

                    @endif
                    @endif
                                </h3>
                            </div>
                        </li>


@endif
                       
                        

                        <li class="nav-item dropdown nav-user">
                            <a class="nav-link nav-user-img text-uppercase text-danger text-bold" href="{{ URL::route('logout') }}" ><i class="far fa-times-circle"></i> Se Déconnecter</a>
                        </li>



                    </ul>
                </div>
            </nav>
        </div>
        <!-- ============================================================== -->
        <!-- end navbar -->
        <!-- ============================================================== -->


            <div class="dashboard-influence">

<div class="container-fluid dashboard-content">

    @yield('content')

</div>


        </div>
        <!-- ============================================================== -->
        <!-- end wrapper  -->
        <!-- ============================================================== -->

</div>    
    <!-- ============================================================== -->
    <!-- end main wrapper  -->
    <!-- ============================================================== -->
    <!-- Optional JavaScript -->
    <!-- jquery 3.3.1 -->
    <script src="{{url('/')}}/assets/vendor/jquery/jquery-3.3.1.min.js"></script>
    <!-- bootstap bundle js -->
    <script src="{{url('/')}}/assets/vendor/bootstrap/js/bootstrap.bundle.js"></script>
    <!-- slimscroll js -->
    <script src="{{url('/')}}/assets/vendor/slimscroll/jquery.slimscroll.js"></script>
    <!-- main js -->
    <script src="{{url('/')}}/assets/libs/js/main-js.js"></script>


    <!-- morris-chart js -->
    <script src="{{url('/')}}/assets/vendor/charts/morris-bundle/raphael.min.js"></script>
    <script src="{{url('/')}}/assets/vendor/charts/morris-bundle/morris.js"></script>
    <script src="{{url('/')}}/assets/vendor/charts/morris-bundle/morrisjs.html"></script>
    
    <!-- chart js -->
    <script src="{{url('/')}}/assets/vendor/charts/charts-bundle/Chart.bundle.js"></script>
    <script src="{{url('/')}}/assets/vendor/charts/charts-bundle/chartjs.js"></script>
    <!-- dashboard js -->
    <script src="{{url('/')}}/assets/libs/js/dashboard-influencer.js"></script>

    <script src="{{url('/')}}/assets/vendor/bootstrap-select/js/bootstrap-select.js"></script>
        
    @yield('JS')

</body>
 
</html>