@extends('layouts.master_panel')

@section('title') Simili  @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Simili</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item"><a href="{{ URL::route('students_index') }}" class="breadcrumb-link">Accueil</a></li>
                                          <li class="breadcrumb-item active" aria-current="page">Simili</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">  
  <div class="card-body">




<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Note</th>
              <th>Matière</th>
              <th>Date</th>
              <th>Enseignant</th>
            </tr>
            </thead>
            <tbody>

@foreach($simili_evaluations as $simili_evaluation)

<?php $GetSimili = \App\Simili::find($simili_evaluation->simili_id); ?>
@if($GetSimili !== null)

                <tr>

                  <td style="display: none;">{{ $simili_evaluation->id }}</td>

                  <td>
                    @if($simili_evaluation->is_absent == 1)
                    <i class="fas fa-exclamation-triangle text-danger" style="font-size: 18px;"></i> <label class="text-danger">Absent(e) </label>

                    @else

                    <?php 

                    echo '<strong style="font-size: 20px;">'.$simili_evaluation->note .' /'.$GetSimili->note_sur.'</strong>';

                     ?>

                    @endif
                  </td>

                  <td> {{ $GetSimili->subject->name }} </td>


                  <td>
                  <?php $enTofr1 = DateTime::createFromFormat('Y-m-d', substr($GetSimili->date, 0, 10)); ?>
                    {{ $enTofr1->format('d/m/Y') }}
                  </td>


                  <td>{{ $GetSimili->teacher->last_name . ' ' . $GetSimili->teacher->first_name }}</td>

                  

                    </tr>
@endif
@endforeach

                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop