<?php

namespace App\Imports;

use Hash;
use App\User;
use Maatwebsite\Excel\Concerns\ToModel;

use Maatwebsite\Excel\Concerns\WithStartRow;

// use Maatwebsite\Excel\Concerns\WithMultipleSheets;


class UsersImport implements ToModel, WithStartRow 
{
    

    public function startRow(): int
    {
        return 2;
    }


    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
        
        if(!empty($row[2]) AND !empty($row[4]) AND !empty($row[5])) {

            $check = User::where('username', $row[4])->Orwhere('email', $row[2])->first();

            if($check  == null) {

                $barcode = date('Y').rand(11111, 99999);

                return new User([
                    'is_teacher'     => 1,
                    'last_name'     => $row[0],
                    'first_name'    => $row[1], 
                    'email'    => $row[2], 
                    'phone'    => $row[3], 
                    'username'    => $row[4], 
                    'password' => Hash::make($row[5]),
                    'barcode' => $barcode + 3,
                ]);

            }

        }
        
    } 
}
