/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RuntimeStatement;
import liquibase.util.StringUtils;

@DatabaseChange(name="output", description="Logs a message and continues execution.", priority=1, since="3.3")
public class OutputChange
extends AbstractChange {
    private String message;
    private String target;

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validate = super.validate(database);
        validate.checkRequiredField("message", this.getMessage());
        return validate;
    }

    @DatabaseChangeProperty(description="Message to output", exampleValue="Make sure you feed the cat", serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = StringUtils.trimToNull(message);
    }

    @DatabaseChangeProperty(description="Target for message. Possible values: STDOUT, STDERR, FATAL, WARN, INFO, DEBUG. Default value: STDERR", exampleValue="STDERR")
    public String getTarget() {
        if (this.target == null) {
            return "STDERR";
        }
        return this.target;
    }

    public void setTarget(String target) {
        this.target = StringUtils.trimToNull(target);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RuntimeStatement(){

            @Override
            public Sql[] generate(Database database) {
                String target = OutputChange.this.getTarget();
                if ("STDOUT".equalsIgnoreCase(target)) {
                    System.out.println(OutputChange.this.getMessage());
                } else if ("STDERR".equalsIgnoreCase(target)) {
                    System.err.println(OutputChange.this.getMessage());
                } else if ("DEBUG".equalsIgnoreCase(target)) {
                    LogService.getLog(this.getClass()).debug(LogType.LOG, OutputChange.this.getMessage());
                } else if ("INFO".equalsIgnoreCase(target)) {
                    LogService.getLog(this.getClass()).info(LogType.LOG, OutputChange.this.getMessage());
                } else if ("WARN".equalsIgnoreCase(target) || "WARNING".equalsIgnoreCase(target)) {
                    LogService.getLog(this.getClass()).warning(LogType.LOG, OutputChange.this.getMessage());
                } else if ("SEVERE".equalsIgnoreCase(target) || "FATAL".equalsIgnoreCase(target) || "ERROR".equalsIgnoreCase(target)) {
                    LogService.getLog(this.getClass()).severe(LogType.LOG, OutputChange.this.getMessage());
                } else {
                    throw new UnexpectedLiquibaseException("Unknown target: " + target);
                }
                return null;
            }
        }};
    }

    @Override
    public String getConfirmationMessage() {
        return "Output: " + this.getMessage();
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        Object value = super.getSerializableFieldValue(field);
        if ("target".equals(field) && "".equals(value)) {
            return null;
        }
        return value;
    }
}

